//
//  DatePickerViewController.m
//  Pickers
//
//  Created by Robert Górczyński on 11-06-22.
//

#import "DatePickerViewController.h"


@implementation DatePickerViewController
@synthesize datePicker; 

- (IBAction)buttonPressed { 
    NSDate *selected = [datePicker date]; 
    NSString *message = [[NSString alloc] initWithFormat: 
						 @"Wybrana przez ciebie data i godzina to: %@", selected]; 
    UIAlertView *alert = [[UIAlertView alloc] 
						  initWithTitle:@"Wybrana data i godzina to" 
						  message:message 
						  delegate:nil 
						  cancelButtonTitle:@"Tak, wybrałem tę datę." 
						  otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
    [message release]; 
} 

- (void)viewDidLoad {
    NSDate *now = [[NSDate alloc] init]; 
    [datePicker setDate:now animated:NO]; 
    [now release]; 
} 

- (void)didReceiveMemoryWarning {
    // Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
    
    // Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.datePicker = nil;
}


- (void)dealloc {
	[datePicker release];
    [super dealloc];
}


@end
